#include <iostream>
#include <iomanip>
#include <string>
#include "material.h"
#include "utils.h"
#include "piece.h"
#include "bits.h"


using namespace std;

cMaterial::cMaterial()
{
 ;
}

void cMaterial::addpiece(const uint &pce, const uint &sq)
{
   ASS(piecegood(pce));
   ASS(pcecount[pce]<maxpiecenum);
   ASS(onbrd(sq));

   pcecount[pce]++;
   pcelist[pce][pcecount[pce]] = sq;

   material[pcecolour(pce)]+=piecevals[pce];

   if(isbigpiece[pce]) bigpieces[pcecolour(pce)]++;
}


void cMaterial::movepiece(const uint &pce, const uint &sqfrom, const uint &sqto)
{
   ASS(piecegood(pce));
   ASS(onbrd(sqfrom));
   ASS(onbrd(sqto));

   uint index = 0;
   for(index = 1; index <= pcecount[pce]; ++index)
   {
        if(pcelist[pce][index]==sqfrom)
        {
           pcelist[pce][index] = sqto;
           return;
        }
   }

   ASS(true==false);
}

void cMaterial::removepiece(const uint &pce, const uint &sq)
{
   ASS(piecegood(pce));
   ASS(pcecount[pce]<maxpiecenum);
   ASS(onbrd(sq));

   uint index,findme=100;
   for(index = 1; index <= pcecount[pce]; ++index)
   {
       if(pcelist[pce][index]==sq)
         {
            findme = index;
            break;
         }
   }
   if(findme==100)
   {
       cout<<"\n uhoh... sq "<<sq<<" piece "<<piecechar(pce);
       printmaterial();
   }
   ASS(findme!=100);

   if(findme!=pcecount[pce])
   {
     pcelist[pce][findme] = pcelist[pce][pcecount[pce]];
     pcelist[pce][pcecount[pce]] = piecedead;//square set to zero
     pcecount[pce]--;
   }
   else
   {
     pcelist[pce][pcecount[pce]] = piecedead;//square set to zero
     pcecount[pce]--;
   }
   material[pcecolour(pce)]-=piecevals[pce];
   if(isbigpiece[pce]) bigpieces[pcecolour(pce)]--;
}

void cMaterial::clearpcelists()
{
   uint piece = 0;
  uint pnum = 0;

  for(piece = pE; piece <= pbK; ++piece)
  {
      ASS(piecegood(piece));
      pcecount[piece] = 0;
      for(pnum = 0; pnum < maxpiecenum; ++pnum)
      {
          pcelist[piece][pnum] = piecedead;
      }
  }

          majors[cW] = 0;
          minors[cW] = 0;
          bigpieces[cW] = 0;
          material[cW] = 0;
          psqvalope[cW] = 0;
          psqvalend[cW] = 0;
          majors[cB] = 0;
          minors[cB] = 0;
          bigpieces[cB] = 0;
          material[cB] = 0;
          psqvalope[cB] = 0;
          psqvalend[cB] = 0;

          pawnbrds[pE]=pawnbrds[pwP]=pawnbrds[pbP]=0;
}

//initialise uint list to the current board
void cMaterial::setpiecelists(const uint *board)
{
        clearpcelists();
        uint squares;
        uint sq;
        uint currentpiece = pE;
        uint currentcolour = cN;
        uint piececounter = 0;

        for(squares = 0; squares < 64; ++squares)
        {
            sq = sqfrom64(squares);
            ASS(onbrd(sq));

            currentpiece = board[sq];

            if(currentpiece==pE) continue;

            currentcolour = pcecolour(currentpiece);

            ASS(piecegood(currentpiece));
            ASS(colourgood(currentcolour));
            ASS(currentpiece!=pE);

            /** pce list set **/
            pcecount[currentpiece]++;
            piececounter = pcecount[currentpiece];

            ASS(piecegood(currentpiece));
            ASS(piececounter<maxpiecenum);

            pcelist[currentpiece][piececounter] = sq;

            /** counter set **/
            if(ismajor[currentpiece]) majors[currentcolour]++;
            else if(isminor[currentpiece]) minors[currentcolour]++;
            if(isbigpiece[currentpiece]) bigpieces[currentcolour]++;

            /** material and psqt set **/
            if(currentpiece < pwK)
             material[currentcolour] += piecevals[currentpiece];

            psqvalope[pcecolour(currentpiece)] += psqt[currentpiece][OPE][sq];
            psqvalend[pcecolour(currentpiece)] += psqt[currentpiece][END][sq];

            /** pawn bitboard set **/
            if(currentpiece==pwP||currentpiece==pbP)
            {
                setbit(sq, pawnbrds[currentpiece]);
            }
        }

  }

void cMaterial::printmaterial()
{
      cout<<endl<<" Material lists : ";

        uint pnum = 0;
        uint currentpiece;
        for(currentpiece = pwP; currentpiece <= pbK; ++currentpiece)
        {
            cout<<endl<<piecechar(currentpiece)<<" ";
            for(pnum = 1; pnum <= pcecount[currentpiece]; ++pnum)
            {
              ASS(piecegood(currentpiece));
              cout<<" "<<printsquare(pcelist[currentpiece][pnum]);
            }
        }
        cout<<endl;
        cout<<setw(8)<<" ";
        cout<<setw(3)<<colourchars[cW]<<setw(3)<<colourchars[cB];
     /*   cout<<setw(8)<<"\n majors"<<setw(5)<<majors[cW]<<setw(5)<<majors[cB];
        cout<<setw(8)<<"\n minors"<<setw(5)<<minors[cW]<<setw(5)<<minors[cB];
        cout<<setw(8)<<"\n bigpce"<<setw(5)<<bigpieces[cW]<<setw(5)<<bigpieces[cB];*/
        cout<<setw(8)<<"\n pawns"<<setw(5)<<pcecount[pwP]<<setw(5)<<pcecount[pbP];
        cout<<setw(8)<<"\n material "<<setw(5)<<endl<<material[cW]<<setw(5)<<material[cB];
        cout<<setw(8)<<"\n psqope "<<setw(5)<<psqvalope[cW]<<endl<<setw(5)<<psqvalope[cB];
        cout<<setw(8)<<"\n psqend "<<setw(5)<<psqvalend[cW]<<endl<<setw(5)<<psqvalend[cB];

        cout<<"\n WP bitbrd : ";
        printbitboard(pawnbrds[pwP]);
        cout<<"\n BP bitbrd : ";
        printbitboard(pawnbrds[pbP]);

}


bool cMaterial::drawmaterial()
{
    if(pcecount[pwP] || pcecount[pbP] ) {return false;}
    if(pcecount[pwR]  || pcecount[pwQ]  || pcecount[pbR]  || pcecount[pbQ] ) {return false;}
    if(pcecount[pwB]  > 1 || pcecount[pbB]  > 1) {return false;}
    if(pcecount[pwN]  && pcecount[pwB] ) {return false;}
    if(pcecount[pbN]  && pcecount[pbB] ) {return false;}
    return true;
}


